//Digital Lighting Controller Slave
//PIC16F1705 driving 4xSi8751


#include "config.h"
#include <xc.h>
#include "io.h"
//#include "tmr0.h"
#include "tmr2.h"
#include "uart.h"

#define _XTAL_FREQ (32000000UL)
#define T2_MAX 680
unsigned char duty[4]={0,0,0,0};        //data on bus
unsigned char baseAdd=0;
//generated by spreadsheet to linearise voltages
 //increase last value to ensure turn on 100% (313=>320)
const int dutyMatch[256]={0,12,17,21,25,27,30,33,35,37,39,41,43,45,47,48,50,52,53,55,56,57,59,60,62,63,64,66,67,68,69,70,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,99,100,101,102,103,104,105,106,107,108,109,109,110,111,112,113,114,115,115,116,117,118,119,120,120,121,122,123,124,125,125,126,127,128,129,130,130,131,132,133,134,134,135,136,137,138,138,139,140,141,141,142,143,144,145,145,146,147,148,149,149,150,151,152,152,153,154,155,156,156,157,158,159,160,160,161,162,163,163,164,165,166,167,167,168,169,170,171,171,172,173,174,174,175,176,177,178,178,179,180,181,182,182,183,184,185,186,187,187,188,189,190,191,192,192,193,194,195,196,197,197,198,199,200,201,202,203,203,204,205,206,207,208,209,210,211,212,213,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,234,235,236,237,238,239,240,242,243,244,245,246,248,249,250,252,253,255,256,257,259,260,262,264,265,267,269,271,273,275,277,279,282,285,287,291,295,300,320};

void main(void) {
    unsigned char d;                 //received data byte
    char frame;             //frame error flag
    static unsigned char byteCount=126;     //#of bytes into frame, >63 => error
    static unsigned char frameType=0xFF;    //first byte of frame
    static int tcycles=0;
    int ttemp;                      //calculated from phase
    static char phaseFlag=0;
    OSCCONbits.IRCF=0b1110;         //32MHz when 4xPLL is on
    ioInit();
    tmr2Init();
    uartInit();
    if(!ADD_4){baseAdd=baseAdd+4;}
    if(!ADD_8){baseAdd=baseAdd+8;}
    if(!ADD_16){baseAdd=baseAdd+16;}
    if(!ADD_32){baseAdd=baseAdd+32;}
    //GIE=1;          //enable interrupts
    CTL_0=0;
    CTL_1=0;
    CTL_2=0;
    CTL_3=0;    
    while(1){
        if(TMR2IF && TMR2IE){
            TMR2IF=0;           //clear flag
            tcycles++;            
            if((tcycles>312)&&(phaseFlag==0)){
                phaseFlag=1;
                if(duty[0]){CTL_0=1;}  //turn on at change (if>0)
                if(duty[1]){CTL_1=1;}  //turn on at change (if>0)
                if(duty[2]){CTL_2=1;}  //turn on at change (if>0)
                if(duty[3]){CTL_3=1;}  //turn on at change (if>0)                
            }                
            if(phaseFlag){
                ttemp=tcycles-313;
            }else{
                ttemp=tcycles;                
            }            
            if(dutyMatch[duty[0]]<=ttemp){CTL_0=0;}     //turn off after duty reached
            if(dutyMatch[duty[1]]<=ttemp){CTL_1=0;}     //turn off after duty reached
            if(dutyMatch[duty[2]]<=ttemp){CTL_2=0;}     //turn off after duty reached
            if(dutyMatch[duty[3]]<=ttemp){CTL_3=0;}     //turn off after duty reached        
            if(tcycles>=T2_MAX){     //this shouldn't happen if we've got mains crossings occurring
                tcycles=T2_MAX;      //clip
                AUX_OUT=1;           //alert
            }else{
                AUX_OUT=0;           //all OK
            }
        }

        if(RCIF && RCIE){
            if(OERR){CREN=0;CREN=1;}   //reset overflow error (serious, but better than locking up)
            RCIF=0;           //clear flag
            frame=FERR;
            d=RC1REG;
            if(frame){
                if(d==0){               //start of frame
                    byteCount=0;        //reset
                    frameType=0xFF;
                }else{                  //data error
                    byteCount=126;      
                }                
            }else{                      //normal data
                if(byteCount==0){       //first byte of frame
                    frameType=d;
                }else{                  //control bytes
                    if(frameType==0){
                        switch(byteCount-baseAdd){
                            //immediate load is OK because we only turn one once, but check for turn off all the time
                            case 1: duty[0]=d; break;
                            case 2: duty[1]=d; break;
                            case 3: duty[2]=d; break;
                            case 4: duty[3]=d; break;
                        }
                    }
                }
                if(byteCount<126){byteCount++;}     //keep count
            }

        }

        if(IOCCF0 && IOCIE){    //pin change interrupt
            IOCCF0=0;           //clear flags
            //check TMR2 so that we avoid noise
            if((!AC_IN)&&(tcycles>255)){         //falling edge precedes zero cross by ~150us                
                phaseFlag=0;
                tcycles=0;          //reset counter
                TMR2=0;             //reset timer to minimise jitter
                TMR2IF=0;           //reset in case of recent trigger
                if(duty[0]){CTL_0=1;}  //turn on at change (if>0)
                if(duty[1]){CTL_1=1;}  //turn on at change (if>0)
                if(duty[2]){CTL_2=1;}  //turn on at change (if>0)
                if(duty[3]){CTL_3=1;}  //turn on at change (if>0)                
            }
        }    
    }
    return;
}


void __interrupt() isr(void){

//    if(TMR0IF && TMR0IE){
//        TMR0IF=0;           //clear flag
//
//    }
}
